
/******************************************************************************
;    (c) 1995-1998 E.M. Serrat		emserrat@geocities.com
;    
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
*******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>
#include <linux/types.h>
#include <linux/cdrom.h>
#include <linux/if_packet.h>
#include <sys/socket.h>

/*-------------------------------------------------------------------------*/
void main(argc, argv)
	int argc;
	int *argv[];
{
	int			cdfd,sockfd,result,addrlen,i,bcnt,lbn;
	char			buf[512],cdname[20];
	struct	sockaddr_ll	addr;
	struct	pooripxheader
	{
		unsigned short	checksum		__attribute__((packed));
		unsigned short	len			__attribute__((packed));
		unsigned char	transport_control	__attribute__((packed));
		unsigned char	packet_type		__attribute__((packed));
		unsigned int	dstnet			__attribute__((packed));
		unsigned char	dstadr[6]		__attribute__((packed));
		unsigned short	dstsock			__attribute__((packed));
		unsigned int	srcnet			__attribute__((packed));
		unsigned char	srcadr[6]		__attribute__((packed));
		unsigned short	srcsock			__attribute__((packed));
	};
	struct 
	{
		unsigned char dest[6]			__attribute__((packed));
		unsigned char src[6]			__attribute__((packed));
		unsigned short prot			__attribute__((packed));
		struct	pooripxheader header;
		int	      lbn			__attribute__((packed));
		int	      bcnt			__attribute__((packed));
		unsigned char filler[504]		__attribute__((packed));
				// Pure COBOL ;-)
	} request;
	struct 
	{
		unsigned char dest[6]			__attribute__((packed));
		unsigned char src[6]			__attribute__((packed));
		unsigned short prot			__attribute__((packed));
		struct	pooripxheader header;
		unsigned char buf[512]			__attribute__((packed));
	} response;

	if (argc != 2)
	{
		printf("Usage: phdserver /dev/hd??? \n");
		exit(0);
	}

	sprintf(cdname,"%s",argv[1]);
  	if ((sockfd=socket(AF_PACKET,SOCK_RAW,0x3838)) == -1) 
	{
    		perror("socket");
    		exit(-1);
  	}
	if ((cdfd=open(cdname,O_RDWR)) < 0)
	{
		perror("Error opening disk block device");
		printf("%s\n",cdname);
		exit(-1);
	}
	
	while(recvfrom(sockfd,&request,556,0,(struct sockaddr *)&addr,&addrlen))
	{
	  response.prot=request.prot;

	  switch (request.header.srcnet)
	  {
	  case 0x01000000:		// Read op
	
	  	for (i=0; i < 6; i++) 
	  	{
			response.dest[i]=request.src[i];
			response.src[i]=request.dest[i];
	  	}
		if (lseek(cdfd,512*request.lbn,SEEK_SET) < 0)
		{
			perror("LSEEK");
			exit(-1);
		}
		while (request.bcnt > 0)
		{
			if (read(cdfd,response.buf,512) < 0)
			{
				perror("READING DISK block device");
				exit(-1);
			}
			if (sendto(sockfd,&response,556,0,(struct sockaddr *)&addr,addrlen) < 0)
			{
				perror("WRITING block to network");
				exit(-1);
			}
			request.bcnt -= 512;
		}
		
	   	break;
	  default:			// Write op
		bcnt = request.header.srcnet;
		lbn  = request.header.dstnet;
	  	for (i=0; i < 6; i++) 
	  	{
			response.dest[i]=request.src[i];
			response.src[i]=request.dest[i];
	  	}
		if (lseek(cdfd,512*lbn,SEEK_SET) < 0)
		{
			perror("LSEEK write op");
			exit(-1);
		}
		if (write(cdfd,(void *)&request.lbn,512) < 0)
		{
			perror("Write");
			exit(-1);
		}
		if (sendto(sockfd,&response,44,0,(struct sockaddr *)&addr,addrlen) < 0)
		{
			perror("WRITING block to network");
			exit(-1);
		}
		bcnt -= 512;
		while (bcnt > 0)
		{
			recvfrom(sockfd,&request,556,0,(struct sockaddr *)&addr,&addrlen);
			if (write(cdfd,(void *)&request.lbn,512) < 0)
			{
				perror("Write");
				exit(-1);
			}
			if (sendto(sockfd,&response,44,0,(struct sockaddr *)&addr,addrlen) < 0)
			{
				perror("WRITING block to network");
				exit(-1);
			}
			bcnt -= 512;
		}
	  }
	}
	close(sockfd);
	close(cdfd);
}
