$! Compile and build webperl.exe  Parameter P1 is pearl source directory
$! containing header and option files needed for building embedded perl.
$!
$! P2 specifies additional compile flags.
$!
$ def_dist = "PERL_ROOT:[000000]"
$ if p1 .eqs. "/" then P1 = def_dist
$ if P1 .eqs. "" then inquire P1 "perl distribution directory (''def_dist')"
$ if P1 .eqs. "" then P1 = def_dist
$!
$! Attempt to determine IEEE flags setting for compile (webperl doesn't
$! currently use floats).
$!
$ ieeeflags = "/float=ieee/ieee=denorm_results"
$!
$! Create a serverapp.pm in [-.system] if not present
$!
$ if f$search("[-.system]serverapp.pm") .eqs. ""
$ then
$   write sys$output "Creating serverapp.pm"
$   create [-.system]serverapp.pm
package ServerApp;
@EXPORT_OK = qw(fetch_hash);
bootstrap ServerApp;
1;
$ endif
$!
$! Compile and link.
$!
$ on control_y then goto cleanup
$ on error then goto cleanup
$ libs = ""
$ save_verify = f$verify(1)
$ if f$type(perl) .nes. ""
$ then
$   define/nolog px perl_root:[lib.extutils]
$   perl px:xsubpp -typemap px:typemap ServerApp.xs ">ServerApp.tc"
$   cc /Include=([],'P1')/Standard=Relaxed_ANSI/Prefix=All -
	'ieeeflags' ServerApp.tc 'P2'
$   libs = "ServerApp.obj,"
$ endif
$ CC /Include=([],'P1')/Standard=Relaxed_ANSI/Prefix=All -
	'ieeeflags' webperl.c 'P2'
$ libs = libs + "cgilib.obj,scriptlib.obj"
$ if f$search("cgilib.obj") .eqs. "" then cc cgilib.c/obj=cgilib.obj
$ if f$search("scriptlib.obj") .eqs. "" then cc scriptlib.c/obj=scriptlib.obj
$ link webperl.obj,'libs','p1'perlshr.opt/Option, perlshr_attr.opt/Options
$ if $status then copy/log webperl.exe [-.system]
$!
$ cleanup:
$ if f$type(save_verify) .nes. "" then save_verify = 'f$verify(save_verify)
