/*
 * Define structures used by hpss_qman application.
 */
/*
 * Job_def structure form a linked list of jobs currently in a queue.
 */
struct job_def {
    struct job_def *next;
    int job_status;
    int in_gateway;
    int entry_number;
    int file_count;
    int job_size;
    long submission_time[2];
    char job_name[40];
    char username[40];
    
};
/*
 * Queue_def structures define a list of 'known' queues and their current
 * state.  The optional gateway queue is the name of a server queue that acts
 * as a front-end to the device queue.
 */
static struct queue_def {
    struct queue_def *next;	/* forward pointer */
    char *name;
    char *gateway;
    char *location;
    struct job_def *first_job, *last_job;
    struct dsc$descriptor_s name_dx, gateway_dx;
    long state;			/* queue status */
    int pending_count;		/* pending job count in gateway queue */
    int age;			/* Seconds since current job submitted */
    long gateway_state;
    int gateway_pending;
    int gateway_age;
};
/*
 * Define prototypes for  functions called between modules.
 */
int send_text ( int *ctx, char *module_name );
int get_module_line ( char *module_name, void **ctx, char *line, 
	int line_size, int *line_length );
int get_queue_status ( struct queue_def *qd, int nested, char *username);
int start_queue ( int *ctx, struct queue_def *qd, char *queue_name,
	char *username );
int delete_queue_entry ( int *ctx, struct queue_def *qd, char *queue_name, 
	char *username, char *path_info );
int release_queue_entry ( int *ctx, struct queue_def *qd, char *queue_name, 
	char *username, char *path_info );
int set_action_log ( char *logfile );
void flush_action_log ();
