/*
 * Provide definitions that were assumed to come from windows.h
 */
#define CONST	const
#define	CHAR	char
#define BYTE	char
#define WORD	short
#define BOOL	unsigned int
#define DWORD	unsigned long int
#define LPDWORD	DWORD *
#define LPBYTE	BYTE *
#define	WINAPI
typedef	void *	LPVOID;
/*
 * Define constants and limits.
 */
#define	HSE_VERSION_MAJOR	1	/* major version */
#define	HSE_VERSION_MINOR	0	/* minor version */
#define	HSE_LOG_BUFFER_LEN	80	/* maximum log message */
#define	HSE_MAX_EXT_DLL_NAME_LEN 256

typedef	LPVOID	HCONN;
typedef char * LPSTR;

/*
** The following are the status codes returned by the
** Extension DLL.
*/
#define	HSE_STATUS_SUCCESS			1
#define	HSE_STATUS_SUCCESS_AND_KEEP_CONN	2
#define	HSE_STATUS_PENDING			3
#define	HSE_STATUS_ERROR			4

/*
** The following are the values to request services with the
** ServerSupportFunction. Values from 0 to 1000 are reserved
** for future versions of the interface.
*/
#define	HSE_REQ_SEND_URL_REDIRECT_RESP	1
#define	HSE_REQ_SEND_URL		2
#define	HSE_REQ_SEND_RESPONSE_HEADER	3
#define	HSE_REQ_DONE_WITH_SESSION	4
#define	HSE_REQ_END_RESERVED		1000
/*
** Structure passed to GetExtensionVersion.
*/
typedef	struct	_HSE_VERSION_INFO {
	DWORD	dwExtensionVersion;
	CHAR	lpszExtensionDesc[HSE_MAX_EXT_DLL_NAME_LEN];
} HSE_VERSION_INFO, *LPHSE_VERSION_INFO;

/*
 * passed to extension procedure on a new request 
 */
typedef struct _EXTENSION_CONTROL_BLOCK { 
    DWORD cbSize; 			/* size of this struct. */
    DWORD dwVersion; 			/* version info of this spec  */
    HCONN ConnID; 			/* Context number, read-only */
    DWORD dwHttpStatusCode; 		/* HTTP Status code to return */
    CHAR lpszLogData[HSE_LOG_BUFFER_LEN]; /* log message */
    /*
     * Following fields value correspond to standard CGI variables.
     */
    LPSTR lpszMethod;
    LPSTR lpszQueryString;
    LPSTR lpszPathInfo;
    LPSTR lpszPathTranslated;
    /*
     * Following fields relate to MIME content sent with HTTP request.
     */
    DWORD cbTotalBytes;		/* content-length if known */
    DWORD cbAvailable;		/* number currently in  lpdData buffer */
    LPBYTE lpbData;		/* Data buffer, 48K minimum */
    LPSTR lpszContentType;	/* Content-type header */
    /*
     * Define callback routines.
     */
    BOOL ( WINAPI * GetServerVariable) ( 
	HCONN hConn, 		/* Connection handle (connid) */
	LPSTR lpszVariableName,
	LPVOID lpvBuffer, 
	LPDWORD lpdwSize ); 
    BOOL ( WINAPI * WriteClient) ( 
	HCONN hConn, 		/* Connection handle (connid) */
	LPVOID Buffer, 
	LPDWORD lpdwBytes, 
	DWORD dwReserved ); 
    BOOL ( WINAPI * ReadClient) ( 
	HCONN hConn, 		/* Connection handle (connid) */
	LPVOID lpvBuffer,
	LPDWORD lpdwSize ); 
    BOOL ( WINAPI * ServerSupportFunction) ( 
	HCONN hConn, 
	DWORD dwHSERRequest, 
	LPVOID lpvBuffer,
	LPDWORD lpdwSize, LPDWORD lpdwDataType ); 
} EXTENSION_CONTROL_BLOCK, *LPEXTENSION_CONTROL_BLOCK;

/*
**  Prototypes for exported Extension DLL function.
*/
BOOL  WINAPI   GetExtensionVersion( HSE_VERSION_INFO  *pVer );
DWORD WINAPI   HttpExtensionProc(  EXTENSION_CONTROL_BLOCK *pECB );
