/*
 * Prototypes for miscellaneous VMS-specific routines to handle 
 * max client computation.  These routines are not thread-safe so must
 * be called from the main thread.
 */
int http_max_server_clients ( 
	int proposed_limit, 	/* desired client limit */
	int cache_size );	/* number of cache slots */

int http_reserve_io ( 
	int multiplier, 	/* max. number of threads */
	int bio, 		/* max. pending buffered I/O per thread */
	int dio, 		/* max. pending direct I/O per thread */
	int channel );		/* max. assigned channels/thread */
int http_reserve_mem ( int multiplier, 
	int npage_byte, 
	int page_byte,
	int astcnt );
int is_sysgrp();	
/* 
 * is_sysgrp returns 1 if UIC is less that SYSGEN parameter MAXSYSGROUP
 */
