/*
 * Define wrapper functions for calling HPSS functions from C.  These
 * functions are not threadsafe.
 */
#include <stdio.h>
#include <stdarg.h>
#include <descrip.h>
#include <string.h>
#include "hpss_share.h"

int hpss_initialize_c ( char *mbx_logical, int mbx_type, INTEGER context )
{
    static $DESCRIPTOR(mbx_dx,"");
    mbx_dx.dsc$w_length = strlen(mbx_logical);
    mbx_dx.dsc$a_pointer = mbx_logical;
    return hpss_initialize ( &mbx_dx, &mbx_type, context );
}

int hpss_accept_c ( INTEGER context, int timeout, INTEGER PID,
	char *function, int func_size )
{
    static $DESCRIPTOR(func_dx,"");
    int i, status;

    func_dx.dsc$w_length = func_size-1;
    func_dx.dsc$a_pointer = function;
    status = hpss_accept ( context, &timeout, PID, &func_dx );
    if ( (status&1) == 1 ) {
        for ( i = 0; i < (func_size-1); i++ ) if ( function[i] == ' ' ) break;
        function[i] = '\0';
    } else function[0] = '\0';

    return status;
}

int hpss_getenv_c ( INTEGER context, char *name, char *value, int val_size,
	INTEGER ret_length )
{
    static $DESCRIPTOR(name_dx,"");
    static $DESCRIPTOR(value_dx,"");
    int status;
    name_dx.dsc$w_length = strlen ( name );
    name_dx.dsc$a_pointer = name;
    value_dx.dsc$w_length = val_size - 1;
    value_dx.dsc$a_pointer = value;
    status = hpss_getenv ( context, &name_dx,  &value_dx, ret_length );
    if ( (status&1) == 1 ) {
	value[*ret_length] = '\0';
    } else value[0] = '\0';
    return status;
}

int hpss_getform_c ( INTEGER context, char *name, char *value, int val_size,
	INTEGER ret_length )
{
    static $DESCRIPTOR(name_dx,"");
    static $DESCRIPTOR(value_dx,"");
    int status;
    name_dx.dsc$w_length = strlen ( name );
    name_dx.dsc$a_pointer = name;
    value_dx.dsc$w_length = val_size - 1;
    value_dx.dsc$a_pointer = value;
    status = hpss_getform ( context, &name_dx,  &value_dx, ret_length );
    if ( (status&1) == 1 ) {
	value[*ret_length] = '\0';
    } else value[0] = '\0';
    return status;
}

int hpss_read_c ( INTEGER context, void *buffer, int bufsize, INTEGER ret_len)
{
    static $DESCRIPTOR(buf_dx,"");
    buf_dx.dsc$w_length = bufsize;
    buf_dx.dsc$a_pointer = buffer;
    return hpss_read ( context, &buf_dx, ret_len );
}

int hpss_write_c ( INTEGER context, void *buffer, int bufsize, int flags )
{
    static $DESCRIPTOR(buf_dx,"");
    buf_dx.dsc$w_length = bufsize;
    buf_dx.dsc$a_pointer = buffer;
    return hpss_write ( context, &buf_dx, &flags );
}
/*
 * The hpss_printf_c function is a convenience function.
 */
int hpss_printf_c ( INTEGER context, const char *fmt, ... )
{
    va_list alist;
    int status, out_len;
    char buffer[32768];
    /*
     * Use magic C function.
     */
    va_start ( alist, fmt );
    out_len = vsprintf ( buffer, fmt, alist );
    va_end ( alist );

    if ( out_len > 0 ) {
	status = hpss_write_c ( context, buffer, out_len, 0 );
    } else if ( out_len == 0 ) {
	status = 1;		/* result was null string */
    } else status = 20;

    return status;
}
