$!
$! DECnet object for running SSL_ENGINE, define required logical names.
$! Place this file in sys$login directory of server process and update
$! base_dir and/or engine symbols for local configuration.
$!
$ set output=00:00:05
$ set verify
$ certificate_file = "dev$disk:[stuff.ssleay.ssleay-0_2_1.apps]server.pem"
$ engine = "www_system:ssl_engine.exe"
$!
$! do some sanity checks.
$!
$ if f$search(engine) .eqs. ""
$ then
$    write sys$Output "SSL_ENGINE executable not found"
$    exit
$ endif
$ if .not. f$file_attribute(engine,"KNOWN") .and. -
	f$privilege("SYSNAM") .eqs."NOSYSNAM"
$ then
$    write sys$output "SSL_ENGINE must be installed with SYSNAM privilege"
$    exit
$  endif
$ if f$search(certificate_file) .eqs. ""
$ then
$    write sys$output "SSL certificate file not found"
$    exit
$ endif
$!
$! define environment variables required by SSL_ENGINE...
$!    ssl_server_certificate points to .pem file that holds server certificate
$!		and RSA private key.
$!
$ define ssl_server_certificate  'certificate_file'
$!
$! ssl_server_access defines list of legal 'clients' for the SSL engine.
$!
$ define ssl_server_access 'f$trnlnm("SYS$NODE")''f$getjpi("0","USERNAME")'
$!
$ define ssl_server_log_level 0
$ define ssl_server_thread_limit 20
$!
$! ssl_server_version sets SSL version(s) to enable.
$!
$ define ssl_server_version 23
$!
$! assume object name is same as filename.
$!
$ objname = f$parse(f$environment("PROCEDURE"),,,"NAME")
$ on error then goto cleanup
$ mcr 'engine' 'objname' 'objname'.log
$ cleanup:
$  deass sys$output
$  purge/keep=8 wwwssl.log
$ exit
$!
$ ssl_cipher = "RC4-MD5:EXP-RC4-MD5:IDEA-CBC-MD5:EXP-RC2-CBC-MD5:DES-CBC-MD5" + -
	":DES-CBC-SHA:DES-CBC3-MD5"
$    run 'base_dir'.ssl]ssl_task
