/*
 * Prototypes for utility functions for accessing 'real-time' counters
 * on the OSU web server.  The counters consists of an arrray of
 * counter blocks in a global section where each counter block holds the
 * statistics for a time interval (e.g. 1 minute).
 *
 * The icbmap_init function
 */
typedef void *icbmap_handle;
int icbmap_open ( 
   int port,				/* primary server port number */
    int sysflag,			/* if non-zero use system lock. */
    int timeout,			/* seconds */
    icbmap_handle *handle );		/* returns handle. */

int icbmap_close ( icbmap_handle handle );
/*
 * The read function returns the most previous 'n' counter blocks.
 * If timeout is non-zero, the function waits for the next update (up to
 * timeout seconds) by the web server before returning the data.
 */
int icbmap_read ( 
	icbmap_handle handle,		/* handle returned by init() */
	struct interval_counter *icb, 	/* Array to recieve read blocks */
	int n,	 			/* size of icb array */
	int timeout,			/* Max seconds to wait */
	int *num_read );		/* Number of icb block written */

/*
 * The set interval function lets the application change the update
 * interval.  A non-positive new_interval does not change the current
 * interval but returns it.
 */
int icbmap_set_interval ( int new_interval, int *old_interval );
