/*
 * Dynamically loaded map routine.
 *
 * Scan ident for invalid VMS filenames containing too many periods and fix,
 * replacing the extra periods with a specified character.
 *
 * To build program, compile and link/share to produce shareable image.
 *
 * Copy fixup.exe to www_system:http_fixup.exe and add following to rule file:
 *    usermap /www/* fspec_fixup,http_fixup,www_system:*.exe
 *    #                routine    image      default-directory
 *
 * Note, shareable image must be installed if http_server.exe is installed.
 *
 * Author:	David Jones
 * Date:	13-FEB-1997
 */
#include "access.h"			/* Access structure. */
#include "ident_map.h"
#include <stdio.h>

/***************************************************************************/
/* Scan ident for filenames with multiple periods and convert to underscores.
 *
 * Return values:
 *	-1	Continue with next rule.
 */
int fspec_fixup ( info_ptr blk, char *translation, int maxlen,
	access_info acc, char **case_preserved, int cp_len )
{
    int last_dot, i, dot_count;
    /*
     * Parse username out of translation (part after pattern).
     */
    for ( dot_count=i=0; (i < maxlen) && translation[i]; i++ ) {
	if ( translation[i] == '.' ) {
	    dot_count++;
	    if ( dot_count > 1 ) {
		translation[last_dot] = blk->value[0];
		if ( case_preserved ) (*case_preserved)[last_dot] = '_';
	    }
	    last_dot = i;
        } else if ( translation[i] == '[' || translation[i] == '<' ) {
	    dot_count = -10000;
	} else if ( translation[i] == '/' || translation[i] == ']' ||
		translation[i] == '>' ) {
	    dot_count = 0;
	}
    }
    return IDENT_MAP_LOOP;
}

int INIT_fspec_fixup ( struct callback_vector *cbvec, int cbvec_size )
{
    return 1;
}
