/*
 * Simple Decnet access routines for DECthreads.
 */
#ifdef VMS
int dnet_initialize ( );
int dnet_connect ( char *taskname, void **dptr );
int dnet_write ( void *dptr, char *buffer, int bufsize, int *written );
int dnet_read ( void *dptr, char *buffer, int bufsize, int *read );
int dnet_read_streamed ( void *dptr, char *buffer, int bufsize, int *read );
int dnet_disconnect ( void *dptr );
int dnet_format_error ( int code, char *buffer, int bufsize );
int dnet_set_time_limit ( void *dptr, int limit );
int dnet_disown_context ( void *dptr );
int dnet_claim_context ( void *dptr );
#else
/*
 * For OSF, make dummy routines to substitute for DECnet.
 */
static int dnet_initialize() { return 1; }
static int dnet_dummy(void * a, ...) { return 0; }
typedef int (* efunc)();
static int dnet_format_error(int code, char *buffer, int bufsize )
   { tu_strnzcpy(buffer,"no DECnet",bufsize-1); return 1; }
#define dnet_connect dnet_dummy
#define dnet_write (efunc) dnet_dummy
#define dnet_read (efunc) dnet_dummy
#define dnet_read_streamed (efunc) dnet_dummy
#define dnet_disconnect (efunc) dnet_dummy
#define dnet_set_time_limit (efunc) dnet_dummy
#define dnet_disown_context (efunc) dnet_dummy
#define dnet_claim_context (efunc) dnet_dummy
#endif
