/*
 * Prototypes for authenticator utility routines: password cache and
 * VMS password checking.  These function are not thread safe and are
 * intended to be called from authenticator programs.
 */
int auth_init_vms_pwd (
	char *iss_user,			/* username to use for intrusion scan */
	long *installed_privs,		/* VMS privilege mask */
	int htbl_size,			/* entries in hash table (power of 2) */
	int limit,			/* max number of cache entries */
	char *timeout );		/* cache entry timeout */

int auth_load_ext_handler ( 
	char *image_name, 		/* Shareable image name */
	int *flags, int *version,
	char ***taglist, int *tlist_size );

int auth_check_vms_password ( 
	char *username, 		/* username to test against */
	char *password, 		/* password to test */
	unsigned char *remote_addr,	/* IP address of source */
	int addr_format );		/* must be zero */

int auth_check_ext_password (
	char *username,
	char *password,
	char *domain,
	char **tag_table,
	unsigned char *remote_addr,
	int addr_format );
/*
 * Checking a password in the cache has the following possible
 * outcomes:
 *    0		Username not found in cache.
 *    1		Username found, password matches and entry is valid.
 *    2		Username found, entry is stale (password not checked, marked as
 *		no match).
 *    3		Username found, entry valid, password does not match.
 */
struct auth_pwd_ctx {
    int username_match;
    int password_match;
    int expired;
    /*
     * Following fields used internally.
     */
    char *cand_username;
    char *cand_password;
    int hndx;				/* Hash table index */
    void *cb;
};
int auth_check_pwd_cache ( 
	char *username,			/* Key for cache entry */
	char *password,
        struct auth_pwd_ctx *ctx );	/* result */
/*
 * The update function either adds a new entry to the cache or updates
 * the expiration time and password of an existing entry depending upon
 * the 
 */
int auth_update_pwd_cache ( struct auth_pwd_ctx *ctx );
/*
 * The follow prototypes are for support of MD5 authentication.
 */
void auth_digest_challenge ( char *header, int hdr_size, char *realm, 
	char *uri );
char *auth_digest_md5 ( char *result,	/* 32 char array to receive result */
	char *fmt, ... );		/* variable number of arguments. */
