 /* **++ **  FACILITY:	MMK  *** **  ABSTRACT:	Source/Target object parser. ** **  MODULE DESCRIPTION:  **@ **  	This module contains routines for parsing MMS object names,, **  which are in one of the following forms: **F **  	OBJECT                     generic object - no suffix, not a file+ **  	OBJECT.SFX                 file object J **      LIB.SFX(OBJECT)            library with library module object with? **                                     implicit file dependency H **  	LIB.SFX(OBJECT=FILE.SF2)   library with libmod object with explicit6 **                                     file dependency **F **  Lists of object names are parsed.  Library specifications may also' **  contain lists of module references.  ** **  AUTHOR: 	    M. Madison 7 **  	    	    COPYRIGHT  1992-1998,  MADGOAT SOFTWARE. " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  20-AUG-1992  ** **  MODIFICATION HISTORY:  **1 **  	20-AUG-1992 V1.0    Madison 	Initial coding. + **  	01-SEP-1992 V1.1    Madison 	Comments. : **  	08-MAR-1993 V1.1-1  Madison 	Fix for library modules.: **  	23-APR-1993 V1.2    Madison 	Improve suffix handling.E **  	29-APR-1993 V1.2-1  Madison 	Handle some suffix-less file cases. H **  	27-SEP-1993 V1.2-2  Madison 	Assume libraries w/no suffix are .OLB.9 **  	22-OCT-1993 V1.2-3  Madison 	Fix blank-line problem. @ **  	02-DEC-1993 V1.2-4  Madison 	Back out intermediate-deletes.> **  	28-JUN-1994 V1.2-5  Madison 	Track modules' file objects.2 **  	01-JUL-1994 V1.3    Madison 	Add CMS support.B **  	22-AUG-1994 V1.3-1  Madison 	Remove KILL_INTERMEDIATES stuff.I **  	28-AUG-1994 V1.4    Madison 	Uniform calling sequence for store rtn. C **  	12-JAN-1995 V1.4-1  Madison 	Defer target libmod dependencies. E **  	30-APR-1995 V1.4-2  Madison 	Don't prefix lib modules if they've ? **  	    	    	    	        already got dev/dir specifications. G **  	29-MAY-1996 V1.4-3  Madison 	Special handling for macros beginning # **  	    	    	    	    	with dots. ? **  	20-JUN-1997 V1.4-4  Madison 	Silently ignore null objects. 2 **  	27-DEC-1998 V1.5    Madison 	General cleanup. **-- */
 #ifdef __DECC # #pragma module PARSE_OBJECTS "V1.5"  #else  #module PARSE_OBJECTS "V1.5" #endif #include "tpadef.h"  #include "mmk.h" #pragma nostandard#     globalvalue int LIB$_SYNTAXERR;  #pragma standard #include "globals.h" #include <fscndef.h>   /*+ ** Private extended TParse state info block  */& #define TPA_C_LENGTH	(TPA$C_LENGTH0+4)% #define TPA_K_COUNT 	(TPA$K_COUNT0+1)        struct TPABLK {      	struct tpadef tpa0;     	int tpa_l_istarget;     	struct QUE *tpa_l_objqptr;      };   /* ** Forward declarations  */  7     void Parse_Objects(char *, int, struct QUE *, int); *     int  parse_obj_store(struct TPABLK *);2     static void process_sfx(struct OBJECT *, int);   /*N ** Parse transition codes; must match corresponding values in PARSE_TABLE.MAR. */   #define PO_K_LIB_BEGIN	 1  #define PO_K_END_OBJ	 2  #define PO_K_APPNAM	 3 #define PO_K_APPNAM_CMS	 4 #define PO_K_LIB_END	 5  #define PO_K_MOD_END	 6  #define PO_K_APPMOD	 7 #define PO_K_APPFIL	 8 #define PO_K_OBJ_INIT	 9 #define PO_K_MOD_FILE	10 #define PO_K_APPGEN	11 #define PO_K_APPGENQ	12    /* ** External references */D     extern int po_state(), po_key();	    	    /* parse table info */ #ifdef __ALPHA#     unsigned int lib$table_parse(); " #define lib$tparse lib$table_parse #endif   /* **++ **  ROUTINE:	Parse_Objects ** **  FUNCTIONAL DESCRIPTION:  **, **  RETURNS:	void (all errrors are signaled) ** **  PROTOTYPE: **H **  	Parse_Objects(char *line, int linelen, sturct OBJECT *object_queue) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:	None.  ** **  SIDE EFFECTS:   	None. ** **-- */Q void Parse_Objects (char *line, int linelen, struct QUE *objque, int is_target) {           struct TPABLK tpablk;      int i, nllen;      unsigned int status;  %     memset(&tpablk, 0, TPA_C_LENGTH); *     tpablk.tpa0.tpa$l_count = TPA_K_COUNT;-     tpablk.tpa0.tpa$l_options = TPA$M_BLANKS; *     tpablk.tpa0.tpa$l_stringcnt = linelen;'     tpablk.tpa0.tpa$l_stringptr = line; &     tpablk.tpa_l_istarget = is_target;"     tpablk.tpa_l_objqptr = objque;  3     status = lib$tparse(&tpablk, po_state, po_key);   H     if (!OK(status)) lib$signal(MMK__PARSERR, 2, linelen, line, status);   } /* Parse_Objects */    /* **++ **  ROUTINE:	PARSE_OBJ_STORE ** **  FUNCTIONAL DESCRIPTION:  **5 **  	Character store routine for use with LIB$TPARSE.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: **C **  	PARSE_OBJ_STORE  flag, inplen, inp, toklen, tok, char, number,  **  	    	    	usrarg  **H ** The first eight arguments are the LIB$TPARSE standard argument block.D ** (Note that LIB$TABLE_PARSE passes the address of the state array,7 **  rather than the state array elements as arguments.)  ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: . **  	SS$_NORMAL: 	normal successful completion **  	Other errors are signaled.  ** **  SIDE EFFECTS:   	None. ** **-- */* int parse_obj_store (struct TPABLK *tpa) {       int len;4     static struct OBJECT *obj = (struct OBJECT *) 0;7     static struct OBJECT *libobj = (struct OBJECT *) 0; 7     static struct OBJECT *filobj = (struct OBJECT *) 0;      struct OBJREF *or;(     struct OBJECT *obj2, *queued_object;     struct DEPEND *dep; *     static char *namptr, *sfxptr, *genptr;  $     switch (tpa->tpa0.tpa$l_param) {       case PO_K_OBJ_INIT:  	obj = mem_get_object();     	namptr = obj->name;     	sfxptr = obj->sfx;      	genptr = obj->cms_gen;      	break;        case PO_K_APPNAM_CMS: #     	obj->type = MMK_K_OBJ_CMSFILE;      case PO_K_APPNAM: /     	*namptr++ = toupper(tpa->tpa0.tpa$b_char);      	*namptr = '\0';     	break;        case PO_K_LIB_BEGIN:     	process_sfx(obj, 0);      	if (obj->sfx[0] == '\0') { "     	    strcpy(obj->sfx, ".OLB");#     	    strcat(obj->name, ".OLB");      	}     	obj->type = MMK_K_OBJ_LIB;      	libobj = obj;      	obj2 = Find_Object(libobj);     	if (obj2 == NULL) {     	    Insert_Object(libobj); 
     	} else { !     	    mem_free_object(libobj);      	    libobj = obj2;      	}     	obj = mem_get_object();     	namptr = obj->name;     	sfxptr = obj->sfx;      	obj->libfile = libobj; "     	obj->type = MMK_K_OBJ_LIBMOD;"     	filobj = (struct OBJECT *) 0;     	break;        case PO_K_APPMOD: /     	*namptr++ = toupper(tpa->tpa0.tpa$b_char);      	*namptr = '\0';     	break;        case PO_K_MOD_FILE:      	filobj = mem_get_object();      	namptr = filobj->name;  	sfxptr = filobj->sfx;#     	filobj->type = MMK_K_OBJ_FILE;      	break;        case PO_K_APPFIL: /     	*namptr++ = toupper(tpa->tpa0.tpa$b_char);      	*namptr = '\0';     	break;        case PO_K_MOD_END:2     case PO_K_LIB_END: if (obj->name[0] != '\0') {       	struct CMD *c; 3     	char tmp[MMK_S_FILE], realobjname[MMK_S_FILE];   (     	if (filobj) process_sfx(filobj, 0); /*F **  Make sure that the library module's object name is just the module	 **  name.  */     	strcpy(tmp, obj->name);$     	extract_name(realobjname, tmp);&     	extract_filename(obj->name, tmp);%     	extract_filetype(obj->sfx, tmp);  /*4 **  Special case for macro names that begin with '.' */9     	if (realobjname[0] == '\0' && obj->sfx[0] != '\0') { '     	    strcpy(realobjname, obj->sfx); %     	    strcpy(obj->name, obj->sfx);      	    obj->sfx[0] = '\0';     	}       	dep = mem_get_depend();     	c = mem_get_cmd(); ,     	dep->cmdqptr = c->flink = c->blink = c; /*B **  Assume the right suffix if one wasn't given.  Take it from the" **  =xxx file, if one was given... */)     	if (obj->sfx[0] == '\0' && filobj) { C     	    if (filobj->sfx[0] != '\0') strcpy(obj->sfx, filobj->sfx);      	}   /*9 **  Or make the assumption based on the library's suffix.  */     	if (obj->sfx[0] == '\0') {      	    struct SFX *s;      	    struct RULE *r;&     	    s = find_suffix(libobj->sfx);     	    if (s) { <     	    	for (s = s->flink; s != &suffixes; s = s->flink) {3     	    	    r = find_rule(libobj->sfx, s->value);      	    	    if (r) break;      	    	} ,     	    	if (r) strcpy(obj->sfx, s->value);
     	    }     	}   /*1 **  Now insert the object into the object tree...  */     	obj2 = Find_Object(obj);      	if (obj2 == NULL) {     	    Insert_Object(obj);
     	} else {      	    mem_free_object(obj);     	    obj = obj2;     	}&     	queued_object = mem_get_object();7     	memcpy(queued_object, obj, sizeof(struct OBJECT)); ;     	queue_insert(queued_object, tpa->tpa_l_objqptr->tail);      	dep->target = obj;  /*E **  Now make sure that the module's file object has the suffix on it, 8 **  if one was given.  If one wasn't given, fake one up. */     	if (filobj) {&     	    if (filobj->sfx[0] == '\0') {(     	    	strcpy(filobj->sfx, obj->sfx);)     	    	strcat(filobj->name, obj->sfx); 
     	    }$     	    obj2 = Find_Object(filobj);     	    if (obj2 == NULL) {      	    	Insert_Object(filobj);     	    } else { "     	    	mem_free_object(filobj);     	    	filobj = obj2;
     	    }     	    or = mem_get_objref();      	    or->obj = filobj;.     	    queue_insert(or, dep->sources.blink);
     	} else {      	    char tmp[MMK_S_FILE];     	    int i; #     	    filobj = mem_get_object(); '     	    filobj->type = MMK_K_OBJ_FILE;  /*I **  If the library module does not have a device/directory specification, = **  assume it's located in the same directory as the library.  */5     	    if (extract_prefix(tmp, realobjname) == 0) { 0     	    	i = extract_prefix(tmp, libobj->name);'     	    	memcpy(filobj->name, tmp, i);      	    } else {      	    	i = 0;
     	    }     	    strcpy(filobj->name+i, =     	    	    realobjname + (realobjname[0] == '.' ? 1 : 0)); 2     	    strcat(filobj->name+i, dep->target->sfx);/     	    strcpy(filobj->sfx, dep->target->sfx); $     	    obj2 = Find_Object(filobj);     	    if (obj2 == NULL) {      	    	Insert_Object(filobj);     	    } else { "     	    	mem_free_object(filobj);     	    	filobj = obj2;
     	    }     	    or = mem_get_objref();      	    or->obj = filobj;.     	    queue_insert(or, dep->sources.blink);     	}     	if (tpa->tpa_l_istarget) { /     	    queue_insert(dep, dep_deferred.blink); 
     	} else { /     	    queue_insert(dep, dep_internal.blink);      	}4     	obj->fileobj = queued_object->fileobj = filobj;(     	obj = filobj = (struct OBJECT *) 0;1     	if (tpa->tpa0.tpa$l_param == PO_K_MOD_END) {       	    obj = mem_get_object();&     	    obj->type = MMK_K_OBJ_LIBMOD;     	    obj->libfile = libobj;      	    namptr = obj->name;
     	} else {      	    libobj = NULL;      	}     	break; 0     } else {  /* silently ignore null modules */1     	if (tpa->tpa0.tpa$l_param == PO_K_MOD_END) {      	    namptr = obj->name;     	    sfxptr = obj->sfx; 
     	} else {      	    mem_free_object(obj);     	    obj = 0;      	    libobj = 0;     	})     	if (filobj) mem_free_object(filobj);      	filobj = 0;     	break;      }        case PO_K_END_OBJ:     	if (obj) { $     	    if (obj->name[0] != '\0') {     	    	process_sfx(obj, 0);     	    	if (obj->type == 0) { 8     	    	    obj->type = obj->sfx[0] ? MMK_K_OBJ_FILE :@     	    	    	OK(file_exists(obj->name, "")) ? MMK_K_OBJ_FILE :%     	    	    	    MMK_K_OBJ_GENERIC;      	    	} 6     	    	queue_insert(obj, tpa->tpa_l_objqptr->tail);4     	    } else {  /* silently ignore null object */     	    	mem_free_object(obj); 
     	    }     	    obj = NULL;     	}     	break;        case PO_K_APPGEN: 8     	if (genptr-obj->cms_gen < sizeof(obj->cms_gen)-1) {*     	    *genptr++ = tpa->tpa0.tpa$b_char;     	    *genptr = '\0';     	}     	break;        default:#     	lib$signal(MMK__PRSTBLERR, 0);        }        return SS$_NORMAL;   } /* parse_obj_store */    /* **++ **  ROUTINE:	process_sfx ** **  FUNCTIONAL DESCRIPTION:  **+ **  	Parses the suffix from an object name.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */< static void process_sfx (struct OBJECT *obj, int chop_off) {       struct dsc$descriptor fdsc;      static struct {      	unsigned short len, code;     	char *ptr;      	unsigned int term; %     } itmlst = {0, FSCN$_TYPE, 0, 0};      unsigned int status;  3     INIT_SDESC(fdsc, strlen(obj->name), obj->name); -     status = sys$filescan(&fdsc, &itmlst, 0); (     if (OK(status) && itmlst.len != 0) {5     	if (itmlst.ptr[itmlst.len] == '~') itmlst.len++; <     	if (itmlst.len > MMK_S_SFX-1) itmlst.len = MMK_S_SFX-1;.     	memcpy(obj->sfx, itmlst.ptr, itmlst.len);!     	obj->sfx[itmlst.len] = '\0'; &     	if (chop_off) *itmlst.ptr = '\0';     } else {     	obj->sfx[0] = '\0';     }    } 